# PYTHON & PASCO: Induksjon
# Versjon: 15.6.2021
# Kontakt: koding@astronomen.no
from pylab import *
import pandas as pd
from matplotlib import pyplot as plt # For å markere arealet under grafen.

# -----------------------Rediger fra her--------------------------------------
filnavn = "induksjon.csv"
startpunkt_data = 900
sluttpunkt_data = 1050
# ----------------------Ikke rediger under------------------------------------

# Importering og tilpasning av data
csv_data = pd.read_csv(open(filnavn, 'r'), delimiter=";", decimal=",")
t_data = csv_data.iloc[:,1].to_numpy(); ems_data = csv_data.iloc[:,2].to_numpy()
t_data = t_data[~isnan(t_data)]; ems_data = ems_data[~isnan(ems_data)]
t_data = t_data[startpunkt_data:sluttpunkt_data]
ems_data = ems_data[startpunkt_data:sluttpunkt_data]

# Numerisk integrasjon
i = 0                       # Indeks for gjennomgang av data
integral = 0                # Kumulativ sum av rektangler under graf
while i <= len(t_data)-2:   # Siste indeks er nest siste element i dataene.
    integral += ems_data[i]*(t_data[i+1] - t_data[i])
    i += 1                  # Går til neste element i dataene

# Utskrift verdi for integralet
print('Den totale fluksforandringen er', integral, 'Wb')

# Plotting av data
plt.fill_between(t_data,ems_data)                   # Markering areal under graf
plot(t_data,ems_data,'g',linewidth=3)               # Plotting data
title('Indusert spenning (EMS) som funksjon av tid')    # Tittel grafvindu
xlabel('Tid / s')                                   # Navn førsteaksen
ylabel('EMS / V')                                   # Navn andreaksen
grid()                                              # Rutenett
show()                                              # Viser grafvinuet. 
