# PYTHON & PASCO: Titrering
# Versjon: 15.6.2021
# Kontakt: koding@astronomen.no
from pylab import *
import pandas as pd

# Importering av data med pandas (pd)
filnavn = "titrering.csv"
csv_data = pd.read_csv(open(filnavn, 'r'), delimiter=";", decimal=",")
volum_data = csv_data.iloc[:,0].to_numpy()
pH_data = csv_data.iloc[:,1].to_numpy()

# Numerisk derivasjon i data.
derivert_data = []              # Tom liste for lagring av den deriverte
i = 0                           # Indeks for iterering gjennom data
while i <= len(volum_data)-2:   # Siste indeks er nest siste
    derivert = (pH_data[i+1] - pH_data[i]) / (volum_data[i+1] - volum_data[i])
    derivert_data.append(derivert)  # Lagring av den deriverte i liste
    i += 1                      # Øker indeksen med 1

# Finner indeksen til den maksimale verdien til den deriverte.
ekvivalens = derivert_data.index(max(derivert_data))
# Bruker indeks til å finne antall mL tilsatt ved ekvivalensspunktet.
print('Halvtitreringspunktet nås etter at',
      round(volum_data[ekvivalens],2),'mL base er tilsatt')

# Plotting av data og den deriverte.
# I plottet, legg merke til at den høyeste toppen i den deriverte samsvarer
# med halvtitreringspunktet
subplot(2,1,1)                              # Første plot i grafrutenettet
plot(volum_data[0:-1], pH_data[0:-1],'go-') # Plotting av måledata
xticks(list(range(14)))                     # Låser verdier langs førsteaksen
title('pH som funksjon av tilført base')    # Tittel første plot
xlabel('mL tilført base')                   # Navn førsteaksen
ylabel('pH')                                # Navn andreaksen
grid()                                      # Rutenett

subplot(2,1,2)                              # Andre plot i grafrutenettet
plot(volum_data[0:-1], derivert_data,'go-') # Plotting av den deriverte
xticks(list(range(14)))                     # Låser verdier langs førsteaksen
title('Endring i pH per mL tilført base')   # Tittel andre plot
xlabel('mL tilført base')                   # Navn førsteakse
ylabel('$\Delta$pH / $\Delta$mL')           # Navn andreakse
grid()                                      # Rutenett
tight_layout()                              # Forhindrer at tekst overlapper
show()                                      # Viser grafrutenettet
