# PYTHON & PASCO: Halveringstid (enkel)
# Versjon: 15.6.2021
# Kontakt: koding@astronomen.no
from pylab import *     #Bibliotek for alt vi trenger av funksjonalitet

# ------------------------ Importering av data ---------------------------------
tid_data = []               # Tom liste for lagring av tidsdata
omdanninger_data = []       # Tom liste for lagring av registrerte omdanninger
with open("Halveringstid.csv") as file:       # Åpner datafilen fra PASCO
    next(file)      # Hopper over overskrift-linjen
    # Løkke over hver linje i datafilen. Linjer leses som tekst/streng
    for line in file:
        # Klargjør data for lagring i lister
        line = line.replace(",",".")      # Bytter desimaltegn
        line = line.replace("\n","")      # Fjerner uønskede linjeskift
        line = line.split(";")            # Splitter streng til liste
        # Tallene i lista står som tekst, konverterer til tall og lagrer
        tid_data.append(float(line[1]))         # Lagrer tidsdataene
        omdanninger_data.append(float(line[2])) # Lagrer registreringer

# ---------------------- Lete etter halveringspunkt ----------------------------
# Finner de to nærmeste halveringspunktene i datasettet¨
N0 = omdanninger_data[0]            # Hvor mange omdanninger vi har i starten
halveringspunkt = N0/2              # Antall omdanninger ved halveringspunktet
antall_målinger = len(omdanninger_data) # Finner antall målinger gjort

# Løkke som leter etter plasseringen til det beste målepunktet
i = 0           # Vi starter på første målepunkt i dataene, teller fra 0
while omdanninger_data[i] > halveringspunkt:
    i +=1       # Hvis vi er over halveringspunktet går vi til neste datapunkt
halveringstid = tid_data[i]             # beste halveringstid lagres
beste_måling = omdanninger_data[i]      # beste måling lagres

# Hvis forsøket ikke startet på t = 0, korrigeres dette ved å
# trekke fra første tidsverdi i tid_data
halveringstid = halveringstid - tid_data[0]

# ----------------------- Utskrift av resultater -------------------------------
print("Antall omdanninger start:", N0)
print("Antall omdanninger halveringspunkt:", halveringspunkt)
print("Beste målepunkt:", beste_måling)
print("Halveringstid", halveringstid)

# ----------------------- Visualisering av data --------------------------------
# Lager halveringslinje for plotting ved å lage to punkt
halveringslinje_y = [halveringspunkt,halveringspunkt] # y-verdier punkter
halveringslinje_t = [tid_data[0],tid_data[-1]]        # t-verdier punkter

# Tegner datasettet
plot(tid_data,omdanninger_data,"bx")             # Plotter datasett
plot(halveringslinje_t,halveringslinje_y,"g--")  # Plotter halveringslinje
title("Omdanninger som funksjon av tid")         # Tittel på plott
xlabel("Tid / s")                                # Navn på x-akse
ylabel("Antall omdanninger per 10 sekunder")     # navn på y-akse
grid()                                           # Rutenett
show()                                           # Viser plottvinduet
