# Energibevaring med SmartCart på skråplan 
from pylab import *
 
# Last inn CSV-fil hentet ut fra PASCO programvare
data = loadtxt('Energi.csv',delimiter=';',skiprows=1)
 
# Les inn data til lister og sett variable
t = data[:,0]
f = data[:,1]
s = (max(data[:,2])-data[:,2])
v = data[:,3]
h = s * 0.05 
m = 0.25
g = 9.81
 
# Regn ut energi som funksjon av tid
Ekin = 0.5 * m * v**2
Epot = m * g * h 
Etot = Ekin + Epot
 
# Plot energien som funksjon av tid
plot(t,Ekin,label='Kinetisk')
plot(t,Epot,label='Potensiell')
plot(t,Etot,label='Sum')
ylabel("Energi (J)")
xlabel("Tid (s)")
xlim([0,8])
title("Energibevaring med SmartCart")
legend()
show()